/*
    EIBD eib bus access and management daemon
    Copyright (C) 2005-2006 Martin K�gler <mkoegler@auto.tuwien.ac.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "timermanager.h"
#include <iostream>
#include <ctime>

TimerManager* TimerManager::instance_m;

TimerManager::TimerManager()
{
}

TimerManager::~TimerManager()
{
  Stop ();
}

TimerManager* TimerManager::instance()
{
  if (instance_m == 0)
    instance_m = new TimerManager();
  return instance_m;
}

void TimerManager::Run (pth_sem_t * stop1)
{
  pth_event_t stop = pth_event (PTH_EVENT_SEM, stop1);
  std::cout << "Starting TimerManager loop." << std::endl;
  while (pth_event_status (stop) != PTH_STATUS_OCCURRED)
  {
    if (taskList_m.empty())
    {
      pth_sleep(10);
    }
    else
    {
			TimerTask* first = taskList_m.front();
			time_t now = time(0);
			time_t nextExec = first->getExecTime();
			if (nextExec <= now)
			{
				if (nextExec > now-60)
				{
					std::cout << "TimerTask execution. " << nextExec << std::endl;
					first->onTimer(now);
				}
				else
					std::cout << "TimerTask skipped due to clock skew or heavy load. " << nextExec << std::endl;
				taskList_m.pop_front();
				first->reschedule(now);
			}
			else
				pth_sleep(1);
    }
  }
  std::cout << "Out of TimerManager loop." << std::endl;
  pth_event_free (stop, PTH_FREE_THIS);
}

void TimerManager::addTask(TimerTask* task)
{
  TaskList_t::iterator it;
  time_t execTime = task->getExecTime();
  for (it = taskList_m.begin(); it != taskList_m.end(); it++)
  {
    if (execTime < (*it)->getExecTime())
      break;
  }
  taskList_m.insert(it, task);
}

void TimerManager::removeTask(TimerTask* task)
{
  taskList_m.remove(task);
}
