/*
    Linknx high level management application
    Copyright (C) 2007 Jean-François Meessen <jf.meessen@ouaye.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TIMERMANAGER_H
#define TIMERMANAGER_H

#include <list>
#include <string>
#include <map>
#include "config.h"
#include "threads.h"

class TimerTask
{
public:
    virtual void onTimer(time_t time) = 0;
    virtual void reschedule(time_t from = 0) = 0;
    virtual time_t getExecTime() = 0;
};

class TimerManager : protected Thread
{
public:
    static TimerManager* instance();
    void addTask(TimerTask* task);
    void removeTask(TimerTask* task);

    void startManager() { Start(); };
    void stopManager() { Stop(); };

private:
    TimerManager();
    virtual ~TimerManager();

    void Run (pth_sem_t * stop);

    typedef std::list<TimerTask*> TaskList_t;
    TaskList_t taskList_m;
    static TimerManager* instance_m;
};

#endif
