/*
    LinKNX KNX home automation platform
    Copyright (C) 2007 Jean-François Meessen <linknx@ouaye.net>

    Portions of code borrowed to EIBD (http://bcusdk.sourceforge.net/)
    Copyright (C) 2005-2006 Martin Kögler <mkoegler@auto.tuwien.ac.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVER_H
#define SERVER_H

#include "threads.h"
#include <list>
#include <string>

class ClientConnection;

class Server : protected Thread
{
public:
    Server (const char *path);
    Server (int port);
    virtual ~ Server ();
    bool deregister (ClientConnection *con);
protected:
    int fd_m;
private:
    std::list<ClientConnection*> connections_m;

    void Run (pth_sem_t * stop);
};

class ClientConnection : public Thread
{
public:
    ClientConnection (Server *server, int fd);
    virtual ~ ClientConnection ();

    int readmessage (pth_event_t stop);
    int sendmessage (int size, const char * msg, pth_event_t stop);
    int sendmessage (const std::string& msg, pth_event_t stop);
    int sendreject (const char* msgstr, pth_event_t stop);

    std::string msg_m;
private:
    int fd_m;
    Server *server_m;

    void Run (pth_sem_t * stop);
};

#endif
