/*
    EIBD eib bus access and management daemon
    Copyright (C) 2005-2006 Martin K�gler <mkoegler@auto.tuwien.ac.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ruleserver.h"

RuleServer::RuleServer()
{
}

RuleServer::~RuleServer()
{
}

void RuleServer::importXml(ticpp::Element* pConfig)
{
  ticpp::Iterator< ticpp::Element > child;
  for ( child = pConfig->FirstChildElement(); child != child.end(); child++ )
  {
    Rule* rule = new Rule();
    rule->importXml(&(*child));
    rulesList_m.push_back(rule);
  }
}

void RuleServer::exportXml(ticpp::Element* pConfig)
{

}

Rule::Rule() : condition_m(0)
{
}

Rule::~Rule()
{
  if (condition_m != 0)
    delete condition_m;

  ActionsList_t::iterator it;
  for(it=actionsList_m.begin(); it != actionsList_m.end(); ++it)
    delete (*it);
}

void Rule::importXml(ticpp::Element* pConfig)
{
  ticpp::Element* pCondition = pConfig->FirstChildElement("condition");
  condition_m = Condition::create(pCondition, this);

  ticpp::Iterator< ticpp::Element > child("action");
  for ( child = pConfig->FirstChildElement("action"); child != child.end(); child++ )
  {
    Action* action = Action::create(&(*child));
    actionsList_m.push_back(action);
  }
}

void Rule::exportXml(ticpp::Element* pConfig)
{
}

void Rule::onChange(Object* object)
{
}

void Rule::evaluate()
{
  ActionsList_t::iterator it;
  if (condition_m->evaluate())
  {
    for(it=actionsList_m.begin(); it != actionsList_m.end(); ++it)
      (*it)->execute();
  }
}

Action* Action::create(const std::string& type)
{
  if (type == "dim-up")
    return new DimUpAction();
//  else if (type == "switch")
//    return new SwitchAction();
//  else if (type == "sms")
//    return new SMSAction();
  else
    return 0;
}

Action* Action::create(ticpp::Element* pConfig)
{
  std::string type = pConfig->GetAttribute("type");
  Action* action = Action::create(type);
  if (action == 0)
  {
		std::stringstream msg;
		msg << "Action type not supported: '" << type << "'";
    throw ticpp::Exception(msg.str());
  }
  action->importXml(pConfig);
  return action;
}

DimUpAction::DimUpAction() : start_m(0), stop_m(255), delay_m(60), object_m(0)
{
}

DimUpAction::~DimUpAction()
{
    if (object_m != 0)
        delete object_m;   
}

void DimUpAction::importXml(ticpp::Element* pConfig)
{
    std::string id;
    id = pConfig->FirstChildElement("object")->GetAttribute("id");
    object_m = ObjectController::instance()->getObject(id);
    pConfig->FirstChildElement("start")->GetText(start_m);
    pConfig->FirstChildElement("stop")->GetText(stop_m);
    pConfig->FirstChildElement("delay")->GetText(delay_m);
}

void DimUpAction::exportXml(ticpp::Element* pConfig)
{
}

void DimUpAction::execute()
{
    std::cout << "TODO: Execute DimUpAction" << std::endl;
}

Condition* Condition::create(const std::string& type, ChangeListener* cl)
{
  if (type == "and")
    return new AndCondition(cl);
  else if (type == "or")
    return new OrCondition(cl);
  else if (type == "object")
    return new ObjectCondition(cl);
  else if (type == "timer")
    return new TimerCondition(cl);
  else
    return 0;
}

Condition* Condition::create(ticpp::Element* pConfig, ChangeListener* cl)
{
  std::string type;
  type = pConfig->GetAttribute("type");
  Condition* condition = Condition::create(type, cl);
  if (condition == 0)
  {
		std::stringstream msg;
		msg << "Condition type not supported: '" << type << "'";
    throw ticpp::Exception(msg.str());
  }
  condition->importXml(pConfig);
  return condition;
}

AndCondition::AndCondition(ChangeListener* cl) : cl_m(cl)
{
}

AndCondition::~AndCondition()
{
  ConditionsList_t::iterator it;
  for(it=conditionsList_m.begin(); it != conditionsList_m.end(); ++it)
    delete (*it);
}

bool AndCondition::evaluate()
{
  ConditionsList_t::iterator it;
  for(it=conditionsList_m.begin(); it != conditionsList_m.end(); ++it)
    if (!(*it)->evaluate())
      return false;
  return true;
}

void AndCondition::importXml(ticpp::Element* pConfig)
{
  ticpp::Iterator< ticpp::Element > child("condition");
  for ( child = pConfig->FirstChildElement("condition"); child != child.end(); child++ )
  {
    Condition* condition = Condition::create(&(*child), cl_m);
    conditionsList_m.push_back(condition);
  }
}

void AndCondition::exportXml(ticpp::Element* pConfig)
{
}
  
OrCondition::OrCondition(ChangeListener* cl) : cl_m(cl)
{
}

OrCondition::~OrCondition()
{
  ConditionsList_t::iterator it;
  for(it=conditionsList_m.begin(); it != conditionsList_m.end(); ++it)
    delete (*it);
}

bool OrCondition::evaluate()
{
  ConditionsList_t::iterator it;
  for(it=conditionsList_m.begin(); it != conditionsList_m.end(); ++it)
    if ((*it)->evaluate())
      return true;
  return false;
}

void OrCondition::importXml(ticpp::Element* pConfig)
{
  ticpp::Iterator< ticpp::Element > child("condition");
  for ( child = pConfig->FirstChildElement("condition"); child != child.end(); child++ )
  {
    Condition* condition = Condition::create(&(*child), cl_m);
    conditionsList_m.push_back(condition);
  }
}

void OrCondition::exportXml(ticpp::Element* pConfig)
{
}
  
ObjectCondition::ObjectCondition(ChangeListener* cl) : cl_m(cl)
{
}

ObjectCondition::~ObjectCondition()
{
}

bool ObjectCondition::evaluate()
{
  if (type_m == "bool")
    return object_m->getBoolValue() == (value_m == "true");
//  if (type_m == "int")
//    return object_m->getIntValue() == atoi(value_m);
  return false;
}

void ObjectCondition::importXml(ticpp::Element* pConfig)
{
    std::string trigger;
    trigger = pConfig->GetAttribute("trigger");
    std::string id;
    id = pConfig->FirstChildElement("object")->GetAttribute("id");
    object_m = ObjectController::instance()->getObject(id);

    if (trigger == "true")
        object_m->addChangeListener(cl_m);

    ticpp::Element* pValue = pConfig->FirstChildElement("value");
    type_m = pValue->GetAttributeOrDefault("type", "bool");
    value_m = pValue->GetText();
}

void ObjectCondition::exportXml(ticpp::Element* pConfig)
{
}
  

TimerCondition::TimerCondition(ChangeListener* cl) : cl_m(cl)
{
}

TimerCondition::~TimerCondition()
{
}

bool TimerCondition::evaluate()
{
  return false;
}

void TimerCondition::importXml(ticpp::Element* pConfig)
{
    std::string trigger;
    trigger = pConfig->GetAttribute("trigger");

    ticpp::Element* pValue = pConfig->FirstChildElement("at");
    at_m = pValue->GetText();

//    if (trigger == "true")
//        timer_m->addChangeListener(cl_m);

}

void TimerCondition::exportXml(ticpp::Element* pConfig)
{
}
  
