###########################################################
#
# argp
#
###########################################################
#
# ARGP_VERSION, ARGP_SITE and ARGP_SOURCE define
# the upstream location of the source code for the package.
# ARGP_DIR is the directory which is created when the source
# archive is unpacked.
# ARGP_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
ARGP_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/bcusdk
ARGP_VERSION=1.3
ARGP_SOURCE=argp-standalone-$(ARGP_VERSION).tar.gz
ARGP_DIR=argp-standalone-$(ARGP_VERSION)
ARGP_UNZIP=zcat
ARGP_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
ARGP_DESCRIPTION=Standalone argp implementation
ARGP_SECTION=util
ARGP_PRIORITY=optional
ARGP_DEPENDS=
ARGP_SUGGESTS=
ARGP_CONFLICTS=

#
# ARGP_IPK_VERSION should be incremented when the ipk changes.
#
ARGP_IPK_VERSION=1

#
# ARGP_CONFFILES should be a list of user-editable files
#ARGP_CONFFILES=/opt/etc/argp.conf /opt/etc/init.d/SXXargp

#
# ARGP_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
#ARGP_PATCHES=$(ARGP_SOURCE_DIR)/configure.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
ARGP_CPPFLAGS=
ARGP_LDFLAGS=

#
# ARGP_BUILD_DIR is the directory in which the build is done.
# ARGP_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# ARGP_IPK_DIR is the directory in which the ipk is built.
# ARGP_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
ARGP_BUILD_DIR=$(BUILD_DIR)/argp
ARGP_SOURCE_DIR=$(SOURCE_DIR)/argp
ARGP_IPK_DIR=$(BUILD_DIR)/argp-$(ARGP_VERSION)-ipk
ARGP_IPK=$(BUILD_DIR)/argp_$(ARGP_VERSION)-$(ARGP_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: argp-source argp-unpack argp argp-stage argp-ipk argp-clean argp-dirclean argp-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(ARGP_SOURCE):
	$(WGET) -P $(DL_DIR) $(ARGP_SITE)/$(ARGP_SOURCE) || \
	$(WGET) -P $(DL_DIR) $(SOURCES_NLO_SITE)/$(ARGP_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
argp-source: $(DL_DIR)/$(ARGP_SOURCE) $(ARGP_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(ARGP_BUILD_DIR)/.configured: $(DL_DIR)/$(ARGP_SOURCE) $(ARGP_PATCHES) make/argp.mk
	rm -rf $(BUILD_DIR)/$(ARGP_DIR) $(@D)
	$(ARGP_UNZIP) $(DL_DIR)/$(ARGP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(ARGP_PATCHES)" ; \
		then cat $(ARGP_PATCHES) | \
		patch -d $(BUILD_DIR)/$(ARGP_DIR) -p0 ; \
	fi
	if test "$(BUILD_DIR)/$(ARGP_DIR)" != "$(@D)" ; \
		then mv $(BUILD_DIR)/$(ARGP_DIR) $(@D) ; \
	fi
	(cd $(@D); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(ARGP_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(ARGP_LDFLAGS)" \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-nls \
		--disable-shared \
		--enable-static \
	)
#	$(PATCH_LIBTOOL) $(@D)/libtool
	touch $@

argp-unpack: $(ARGP_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(ARGP_BUILD_DIR)/.built: $(ARGP_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(@D)
	touch $@

#
# This is the build convenience target.
#
argp: $(ARGP_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(ARGP_BUILD_DIR)/.staged: $(ARGP_BUILD_DIR)/.built
	rm -f $@
	$(MAKE) -C $(@D) DESTDIR=$(STAGING_DIR) install
	touch $@

argp-stage: $(ARGP_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/argp
#
$(ARGP_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: argp" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(ARGP_PRIORITY)" >>$@
	@echo "Section: $(ARGP_SECTION)" >>$@
	@echo "Version: $(ARGP_VERSION)-$(ARGP_IPK_VERSION)" >>$@
	@echo "Maintainer: $(ARGP_MAINTAINER)" >>$@
	@echo "Source: $(ARGP_SITE)/$(ARGP_SOURCE)" >>$@
	@echo "Description: $(ARGP_DESCRIPTION)" >>$@
	@echo "Depends: $(ARGP_DEPENDS)" >>$@
	@echo "Suggests: $(ARGP_SUGGESTS)" >>$@
	@echo "Conflicts: $(ARGP_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(ARGP_IPK_DIR)/opt/sbin or $(ARGP_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(ARGP_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(ARGP_IPK_DIR)/opt/etc/argp/...
# Documentation files should be installed in $(ARGP_IPK_DIR)/opt/doc/argp/...
# Daemon startup scripts should be installed in $(ARGP_IPK_DIR)/opt/etc/init.d/S??argp
#
# You may need to patch your application to make it use these locations.
#
$(ARGP_IPK): $(ARGP_BUILD_DIR)/.built
	rm -rf $(ARGP_IPK_DIR) $(BUILD_DIR)/argp_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(ARGP_BUILD_DIR) DESTDIR=$(ARGP_IPK_DIR) install-strip
#	install -d $(ARGP_IPK_DIR)/opt/etc/
#	install -m 644 $(ARGP_SOURCE_DIR)/argp.conf $(ARGP_IPK_DIR)/opt/etc/argp.conf
#	install -d $(ARGP_IPK_DIR)/opt/etc/init.d
#	install -m 755 $(ARGP_SOURCE_DIR)/rc.argp $(ARGP_IPK_DIR)/opt/etc/init.d/SXXargp
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(ARGP_IPK_DIR)/opt/etc/init.d/SXXargp
	$(MAKE) $(ARGP_IPK_DIR)/CONTROL/control
#	install -m 755 $(ARGP_SOURCE_DIR)/postinst $(ARGP_IPK_DIR)/CONTROL/postinst
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(ARGP_IPK_DIR)/CONTROL/postinst
#	install -m 755 $(ARGP_SOURCE_DIR)/prerm $(ARGP_IPK_DIR)/CONTROL/prerm
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(ARGP_IPK_DIR)/CONTROL/prerm
#	if test -n "$(UPD-ALT_PREFIX)"; then \
		sed -i -e '/^[ 	]*update-alternatives /s|update-alternatives|$(UPD-ALT_PREFIX)/bin/&|' \
			$(ARGP_IPK_DIR)/CONTROL/postinst $(ARGP_IPK_DIR)/CONTROL/prerm; \
	fi
	echo $(ARGP_CONFFILES) | sed -e 's/ /\n/g' > $(ARGP_IPK_DIR)/CONTROL/conffiles
	cd $(BUILD_DIR); $(IPKG_BUILD) $(ARGP_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
argp-ipk: $(ARGP_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
argp-clean:
	rm -f $(ARGP_BUILD_DIR)/.built
	-$(MAKE) -C $(ARGP_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
argp-dirclean:
	rm -rf $(BUILD_DIR)/$(ARGP_DIR) $(ARGP_BUILD_DIR) $(ARGP_IPK_DIR) $(ARGP_IPK)
#
#
# Some sanity check for the package.
#
argp-check: $(ARGP_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(ARGP_IPK)
