###########################################################
#
# log4cpp
#
###########################################################
#
# LOG4CPP_VERSION, LOG4CPP_SITE and LOG4CPP_SOURCE define
# the upstream location of the source code for the package.
# LOG4CPP_DIR is the directory which is created when the source
# archive is unpacked.
# LOG4CPP_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
LOG4CPP_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/log4cpp
LOG4CPP_VERSION=1.0
LOG4CPP_SOURCE=log4cpp-$(LOG4CPP_VERSION).tar.gz
LOG4CPP_DIR=log4cpp-$(LOG4CPP_VERSION)
LOG4CPP_UNZIP=zcat
LOG4CPP_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
LOG4CPP_DESCRIPTION=Describe log4cpp here.
LOG4CPP_SECTION=lib
LOG4CPP_PRIORITY=optional
LOG4CPP_DEPENDS=
LOG4CPP_SUGGESTS=
LOG4CPP_CONFLICTS=

#
# LOG4CPP_IPK_VERSION should be incremented when the ipk changes.
#
LOG4CPP_IPK_VERSION=1

#
# LOG4CPP_CONFFILES should be a list of user-editable files
#LOG4CPP_CONFFILES=/opt/etc/log4cpp.conf /opt/etc/init.d/SXXlog4cpp

#
# LOG4CPP_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
#LOG4CPP_PATCHES=$(LOG4CPP_SOURCE_DIR)/configure.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
LOG4CPP_CPPFLAGS=
LOG4CPP_LDFLAGS=

#
# LOG4CPP_BUILD_DIR is the directory in which the build is done.
# LOG4CPP_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# LOG4CPP_IPK_DIR is the directory in which the ipk is built.
# LOG4CPP_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
LOG4CPP_BUILD_DIR=$(BUILD_DIR)/log4cpp
LOG4CPP_SOURCE_DIR=$(SOURCE_DIR)/log4cpp
LOG4CPP_IPK_DIR=$(BUILD_DIR)/log4cpp-$(LOG4CPP_VERSION)-ipk
LOG4CPP_IPK=$(BUILD_DIR)/log4cpp_$(LOG4CPP_VERSION)-$(LOG4CPP_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: log4cpp-source log4cpp-unpack log4cpp log4cpp-stage log4cpp-ipk log4cpp-clean log4cpp-dirclean log4cpp-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(LOG4CPP_SOURCE):
	$(WGET) -P $(DL_DIR) $(LOG4CPP_SITE)/$(LOG4CPP_SOURCE) || \
	$(WGET) -P $(DL_DIR) $(SOURCES_NLO_SITE)/$(LOG4CPP_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
log4cpp-source: $(DL_DIR)/$(LOG4CPP_SOURCE) $(LOG4CPP_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(LOG4CPP_BUILD_DIR)/.configured: $(DL_DIR)/$(LOG4CPP_SOURCE) $(LOG4CPP_PATCHES) make/log4cpp.mk
#	$(MAKE) <bar>-stage <baz>-stage
	rm -rf $(BUILD_DIR)/$(LOG4CPP_DIR) $(@D)
	$(LOG4CPP_UNZIP) $(DL_DIR)/$(LOG4CPP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(LOG4CPP_PATCHES)" ; \
		then cat $(LOG4CPP_PATCHES) | \
		patch -d $(BUILD_DIR)/$(LOG4CPP_DIR) -p0 ; \
	fi
	if test "$(BUILD_DIR)/$(LOG4CPP_DIR)" != "$(@D)" ; \
		then mv $(BUILD_DIR)/$(LOG4CPP_DIR) $(@D) ; \
	fi
	(cd $(@D); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(LOG4CPP_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(LOG4CPP_LDFLAGS)" \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-nls \
		--disable-static \
		--disable-doxygen \
	)
	$(PATCH_LIBTOOL) $(@D)/libtool
	touch $@

log4cpp-unpack: $(LOG4CPP_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(LOG4CPP_BUILD_DIR)/.built: $(LOG4CPP_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(@D)
	touch $@

#
# This is the build convenience target.
#
log4cpp: $(LOG4CPP_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(LOG4CPP_BUILD_DIR)/.staged: $(LOG4CPP_BUILD_DIR)/.built
	rm -f $@
	$(MAKE) -C $(@D) DESTDIR=$(STAGING_DIR) install
	touch $@

log4cpp-stage: $(LOG4CPP_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/log4cpp
#
$(LOG4CPP_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: log4cpp" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(LOG4CPP_PRIORITY)" >>$@
	@echo "Section: $(LOG4CPP_SECTION)" >>$@
	@echo "Version: $(LOG4CPP_VERSION)-$(LOG4CPP_IPK_VERSION)" >>$@
	@echo "Maintainer: $(LOG4CPP_MAINTAINER)" >>$@
	@echo "Source: $(LOG4CPP_SITE)/$(LOG4CPP_SOURCE)" >>$@
	@echo "Description: $(LOG4CPP_DESCRIPTION)" >>$@
	@echo "Depends: $(LOG4CPP_DEPENDS)" >>$@
	@echo "Suggests: $(LOG4CPP_SUGGESTS)" >>$@
	@echo "Conflicts: $(LOG4CPP_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(LOG4CPP_IPK_DIR)/opt/sbin or $(LOG4CPP_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(LOG4CPP_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(LOG4CPP_IPK_DIR)/opt/etc/log4cpp/...
# Documentation files should be installed in $(LOG4CPP_IPK_DIR)/opt/doc/log4cpp/...
# Daemon startup scripts should be installed in $(LOG4CPP_IPK_DIR)/opt/etc/init.d/S??log4cpp
#
# You may need to patch your application to make it use these locations.
#
$(LOG4CPP_IPK): $(LOG4CPP_BUILD_DIR)/.built
	rm -rf $(LOG4CPP_IPK_DIR) $(BUILD_DIR)/log4cpp_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(LOG4CPP_BUILD_DIR) DESTDIR=$(LOG4CPP_IPK_DIR) install-strip
#	install -d $(LOG4CPP_IPK_DIR)/opt/etc/
#	install -m 644 $(LOG4CPP_SOURCE_DIR)/log4cpp.conf $(LOG4CPP_IPK_DIR)/opt/etc/log4cpp.conf
#	install -d $(LOG4CPP_IPK_DIR)/opt/etc/init.d
#	install -m 755 $(LOG4CPP_SOURCE_DIR)/rc.log4cpp $(LOG4CPP_IPK_DIR)/opt/etc/init.d/SXXlog4cpp
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LOG4CPP_IPK_DIR)/opt/etc/init.d/SXXlog4cpp
	$(MAKE) $(LOG4CPP_IPK_DIR)/CONTROL/control
#	install -m 755 $(LOG4CPP_SOURCE_DIR)/postinst $(LOG4CPP_IPK_DIR)/CONTROL/postinst
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LOG4CPP_IPK_DIR)/CONTROL/postinst
#	install -m 755 $(LOG4CPP_SOURCE_DIR)/prerm $(LOG4CPP_IPK_DIR)/CONTROL/prerm
#	sed -i -e '/^#!/aOPTWARE_TARGET=${OPTWARE_TARGET}' $(LOG4CPP_IPK_DIR)/CONTROL/prerm
#	if test -n "$(UPD-ALT_PREFIX)"; then \
		sed -i -e '/^[ 	]*update-alternatives /s|update-alternatives|$(UPD-ALT_PREFIX)/bin/&|' \
			$(LOG4CPP_IPK_DIR)/CONTROL/postinst $(LOG4CPP_IPK_DIR)/CONTROL/prerm; \
	fi
	echo $(LOG4CPP_CONFFILES) | sed -e 's/ /\n/g' > $(LOG4CPP_IPK_DIR)/CONTROL/conffiles
	cd $(BUILD_DIR); $(IPKG_BUILD) $(LOG4CPP_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
log4cpp-ipk: $(LOG4CPP_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
log4cpp-clean:
	rm -f $(LOG4CPP_BUILD_DIR)/.built
	-$(MAKE) -C $(LOG4CPP_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
log4cpp-dirclean:
	rm -rf $(BUILD_DIR)/$(LOG4CPP_DIR) $(LOG4CPP_BUILD_DIR) $(LOG4CPP_IPK_DIR) $(LOG4CPP_IPK)
#
#
# Some sanity check for the package.
#
log4cpp-check: $(LOG4CPP_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(LOG4CPP_IPK)
