###########################################################
#
# linknx
#
###########################################################
#
# LINKNX_VERSION, LINKNX_SITE and LINKNX_SOURCE define
# the upstream location of the source code for the package.
# LINKNX_DIR is the directory which is created when the source
# archive is unpacked.
# LINKNX_UNZIP is the command used to unzip the source.
# It is usually "zcat" (for .gz) or "bzcat" (for .bz2)
#
# You should change all these variables to suit your package.
# Please make sure that you add a description, and that you
# list all your packages' dependencies, seperated by commas.
# 
# If you list yourself as MAINTAINER, please give a valid email
# address, and indicate your irc nick if it cannot be easily deduced
# from your name or email address.  If you leave MAINTAINER set to
# "NSLU2 Linux" other developers will feel free to edit.
#
LINKNX_SITE=http://$(SOURCEFORGE_MIRROR)/sourceforge/linknx
LINKNX_VERSION=0.0.1.28
LINKNX_SOURCE=linknx-$(LINKNX_VERSION).tar.gz
LINKNX_DIR=linknx-$(LINKNX_VERSION)
LINKNX_UNZIP=zcat
LINKNX_MAINTAINER=NSLU2 Linux <nslu2-linux@yahoogroups.com>
LINKNX_DESCRIPTION=KNX home automation platform
LINKNX_SECTION=util
LINKNX_PRIORITY=optional
LINKNX_DEPENDS=
LINKNX_SUGGESTS=
LINKNX_CONFLICTS=

#
# LINKNX_IPK_VERSION should be incremented when the ipk changes.
#
LINKNX_IPK_VERSION=1

#
# LINKNX_CONFFILES should be a list of user-editable files
LINKNX_CONFFILES=

#
# LINKNX_PATCHES should list any patches, in the the order in
# which they should be applied to the source code.
#
#LINKNX_PATCHES=$(LINKNX_SOURCE_DIR)/configure.patch

#
# If the compilation of the package requires additional
# compilation or linking flags, then list them here.
#
LINKNX_CPPFLAGS=
LINKNX_LDFLAGS=

#
# LINKNX_BUILD_DIR is the directory in which the build is done.
# LINKNX_SOURCE_DIR is the directory which holds all the
# patches and ipkg control files.
# LINKNX_IPK_DIR is the directory in which the ipk is built.
# LINKNX_IPK is the name of the resulting ipk files.
#
# You should not change any of these variables.
#
LINKNX_BUILD_DIR=$(BUILD_DIR)/linknx
LINKNX_SOURCE_DIR=$(SOURCE_DIR)/linknx
LINKNX_IPK_DIR=$(BUILD_DIR)/linknx-$(LINKNX_VERSION)-ipk
LINKNX_IPK=$(BUILD_DIR)/linknx_$(LINKNX_VERSION)-$(LINKNX_IPK_VERSION)_$(TARGET_ARCH).ipk

.PHONY: linknx-source linknx-unpack linknx linknx-stage linknx-ipk linknx-clean linknx-dirclean linknx-check

#
# This is the dependency on the source code.  If the source is missing,
# then it will be fetched from the site using wget.
#
$(DL_DIR)/$(LINKNX_SOURCE):
	$(WGET) -P $(DL_DIR) $(LINKNX_SITE)/$(LINKNX_SOURCE) || \
	$(WGET) -P $(DL_DIR) $(SOURCES_NLO_SITE)/$(LINKNX_SOURCE)

#
# The source code depends on it existing within the download directory.
# This target will be called by the top level Makefile to download the
# source code's archive (.tar.gz, .bz2, etc.)
#
linknx-source: $(DL_DIR)/$(LINKNX_SOURCE) $(LINKNX_PATCHES)

#
# This target unpacks the source code in the build directory.
# If the source archive is not .tar.gz or .tar.bz2, then you will need
# to change the commands here.  Patches to the source code are also
# applied in this target as required.
#
# This target also configures the build within the build directory.
# Flags such as LDFLAGS and CPPFLAGS should be passed into configure
# and NOT $(MAKE) below.  Passing it to configure causes configure to
# correctly BUILD the Makefile with the right paths, where passing it
# to Make causes it to override the default search paths of the compiler.
#
# If the compilation of the package requires other packages to be staged
# first, then do that first (e.g. "$(MAKE) <bar>-stage <baz>-stage").
#
# If the package uses  GNU libtool, you should invoke $(PATCH_LIBTOOL) as
# shown below to make various patches to it.
#
$(LINKNX_BUILD_DIR)/.configured: $(DL_DIR)/$(LINKNX_SOURCE) $(LINKNX_PATCHES) make/linknx.mk
	$(MAKE) pthsem-stage libcurl-stage lua-stage libesmtp-nothread-stage
	rm -rf $(BUILD_DIR)/$(LINKNX_DIR) $(LINKNX_BUILD_DIR)
	$(LINKNX_UNZIP) $(DL_DIR)/$(LINKNX_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	if test -n "$(LINKNX_PATCHES)" ; \
		then cat $(LINKNX_PATCHES) | \
		patch -d $(BUILD_DIR)/$(LINKNX_DIR) -p0 ; \
	fi
	if test "$(BUILD_DIR)/$(LINKNX_DIR)" != "$(LINKNX_BUILD_DIR)" ; \
		then mv $(BUILD_DIR)/$(LINKNX_DIR) $(LINKNX_BUILD_DIR) ; \
	fi
	(cd $(LINKNX_BUILD_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		CPPFLAGS="$(STAGING_CPPFLAGS) $(LINKNX_CPPFLAGS)" \
		LDFLAGS="$(STAGING_LDFLAGS) $(LINKNX_LDFLAGS)" \
	        PKG_CONFIG_LIBDIR=$(STAGING_PREFIX)/lib/pkgconfig \
		PATH=$(STAGING_DIR)/opt/bin:$$PATH \
		./configure \
		--build=$(GNU_HOST_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/opt \
		--disable-nls \
		--disable-static \
		--without-pth-test \
		--with-libcurl=$(STAGING_DIR) \
		--enable-smtp=static \
		--with-lua \
		--without-log4cpp \
		--without-mysql \
	)
#	$(PATCH_LIBTOOL) $(LINKNX_BUILD_DIR)/libtool
	touch $@

linknx-unpack: $(LINKNX_BUILD_DIR)/.configured

#
# This builds the actual binary.
#
$(LINKNX_BUILD_DIR)/.built: $(LINKNX_BUILD_DIR)/.configured
	rm -f $@
	$(MAKE) -C $(LINKNX_BUILD_DIR)
	touch $@

#
# This is the build convenience target.
#
linknx: $(LINKNX_BUILD_DIR)/.built

#
# If you are building a library, then you need to stage it too.
#
$(LINKNX_BUILD_DIR)/.staged: $(LINKNX_BUILD_DIR)/.built
	rm -f $@
	$(MAKE) -C $(LINKNX_BUILD_DIR) DESTDIR=$(STAGING_DIR) install
	touch $@

linknx-stage: $(LINKNX_BUILD_DIR)/.staged

#
# This rule creates a control file for ipkg.  It is no longer
# necessary to create a seperate control file under sources/linknx
#
$(LINKNX_IPK_DIR)/CONTROL/control:
	@install -d $(@D)
	@rm -f $@
	@echo "Package: linknx" >>$@
	@echo "Architecture: $(TARGET_ARCH)" >>$@
	@echo "Priority: $(LINKNX_PRIORITY)" >>$@
	@echo "Section: $(LINKNX_SECTION)" >>$@
	@echo "Version: $(LINKNX_VERSION)-$(LINKNX_IPK_VERSION)" >>$@
	@echo "Maintainer: $(LINKNX_MAINTAINER)" >>$@
	@echo "Source: $(LINKNX_SITE)/$(LINKNX_SOURCE)" >>$@
	@echo "Description: $(LINKNX_DESCRIPTION)" >>$@
	@echo "Depends: $(LINKNX_DEPENDS)" >>$@
	@echo "Suggests: $(LINKNX_SUGGESTS)" >>$@
	@echo "Conflicts: $(LINKNX_CONFLICTS)" >>$@

#
# This builds the IPK file.
#
# Binaries should be installed into $(LINKNX_IPK_DIR)/opt/sbin or $(LINKNX_IPK_DIR)/opt/bin
# (use the location in a well-known Linux distro as a guide for choosing sbin or bin).
# Libraries and include files should be installed into $(LINKNX_IPK_DIR)/opt/{lib,include}
# Configuration files should be installed in $(LINKNX_IPK_DIR)/opt/etc/linknx/...
# Documentation files should be installed in $(LINKNX_IPK_DIR)/opt/doc/linknx/...
# Daemon startup scripts should be installed in $(LINKNX_IPK_DIR)/opt/etc/init.d/S??linknx
#
# You may need to patch your application to make it use these locations.
#
$(LINKNX_IPK): $(LINKNX_BUILD_DIR)/.built
	rm -rf $(LINKNX_IPK_DIR) $(BUILD_DIR)/linknx_*_$(TARGET_ARCH).ipk
	$(MAKE) -C $(LINKNX_BUILD_DIR) DESTDIR=$(LINKNX_IPK_DIR) install-strip
	$(MAKE) $(LINKNX_IPK_DIR)/CONTROL/control
	cd $(BUILD_DIR); $(IPKG_BUILD) $(LINKNX_IPK_DIR)

#
# This is called from the top level makefile to create the IPK file.
#
linknx-ipk: $(LINKNX_IPK)

#
# This is called from the top level makefile to clean all of the built files.
#
linknx-clean:
	rm -f $(LINKNX_BUILD_DIR)/.built
	-$(MAKE) -C $(LINKNX_BUILD_DIR) clean

#
# This is called from the top level makefile to clean all dynamically created
# directories.
#
linknx-dirclean:
	rm -rf $(BUILD_DIR)/$(LINKNX_DIR) $(LINKNX_BUILD_DIR) $(LINKNX_IPK_DIR) $(LINKNX_IPK)
#
#
# Some sanity check for the package.
#
linknx-check: $(LINKNX_IPK)
	perl scripts/optware-check-package.pl --target=$(OPTWARE_TARGET) $(LINKNX_IPK)
